//Experiment-4
// windows - 7 - 64-Bit
//Scilab - 5.4.1


//AIM:  Develop a program to plot torque-speed characteristics of single phase full controlled rectifier fed separately excited DC motor
clear
clc
Vs=230;                          // SUPPLY VOLTAGE IN VOLT
Vm=Vs*sqrt(2);       //MAXIMUM VOLTAGE IN VOLT
f=50 ;                // FREQUENCY IN Hz
w=2*%pi*f
                  
Wr=1500*%pi/30;       // RATED SPEED IN r.p.s.      
Ia=11.6;                 // ARMATURE CURRENT IN AMP   
Ra=1.5;                // ARMATURE RESISTANCE IN OHM
La=0.6e-6;            // ARMAURE INDUCTANCE IN HENRY

Va=220;              //ARMATURE VOLTAGE IN VOLT
E = Va-(Ia*Ra);          // BACK EMF IN VOLT  
K = E/Wr
Wmo=Vm/K;            // NO LOAD SPEED IN r.p.s.
Z=sqrt(Ra^2+(w*La)^2); // Calculation of impedance
fai=atan((w*La)/Ra)
Tr=E*Ia/Wr;         // RATED TORQUE IN Nm
j=1;

for  alpha=30                      // For  Firing angle = 30 degree
alphar=alpha*%pi/180;
i=1;
    for Wm = - Wmo:10:Wmo;
    Wmi(j,i)=Wm;
    eta=%pi+alphar;
    ia=(Vm*sin(eta-fai)/Z)-(K*Wm/Ra)+(((K*Wm/Ra)-(Vm*sin(alphar-fai)/Z))*exp((alphar-eta)*cotg(fai)));
        if ia<=0   then                               // if current is discontinuous
            for beta=(alpha+0.1):0.1:360
            betar=beta*%pi/180;
            ia=(Vm*sin(betar-fai)/Z)-(K*Wm/Ra)+(((K*Wm/Ra)-(Vm*sin(alphar-fai)/Z))*exp((alphar-betar)*cotg(fai)));
                if ia<=0.00001 then
                break;
                end
            end
        Tor1(j,i)=((Vm*K*(cos(alphar)-cos(betar)))-(Wm*K^2*(betar-alphar)))/(%pi*Ra);
        else
        Tor1(j,i)=((Vm*K*(1+cos(alphar))/%pi)-(Wm*K^2))/Ra;
        end
        i=i+1;
    end
j=j+1;
end
plot(Wmi',Tor1','k','LineWidth',2)

for  alpha=60                      // For  Firing angle = 60 degree
alphar=alpha*%pi/180;
i=1;
    for Wm = - Wmo:10:Wmo;
    Wmi(j,i)=Wm;
    eta=%pi+alphar;
    ia=(Vm*sin(eta-fai)/Z)-(K*Wm/Ra)+(((K*Wm/Ra)-(Vm*sin(alphar-fai)/Z))*exp((alphar-eta)*cotg(fai)));
        if ia<=0   then                               // if current is discontinuous
            for beta=(alpha+0.1):0.1:360
            betar=beta*%pi/180;
            ia=(Vm*sin(betar-fai)/Z)-(K*Wm/Ra)+(((K*Wm/Ra)-(Vm*sin(alphar-fai)/Z))*exp((alphar-betar)*cotg(fai)));
                if ia<=0.00001 then
                break;
                end
            end
        Tor2(j,i)=((Vm*K*(cos(alphar)-cos(betar)))-(Wm*K^2*(betar-alphar)))/(%pi*Ra);
        else
        Tor2(j,i)=((Vm*K*(1+cos(alphar))/%pi)-(Wm*K^2))/Ra;
        end
        i=i+1;
    end
j=j+1;
end
plot(Wmi',Tor2','b','LineWidth',2)

for  alpha=90                      // For  Firing angle = 90 degree
alphar=alpha*%pi/180;
i=1;
    for Wm = - Wmo:10:Wmo;
    Wmi(j,i)=Wm;
    eta=%pi+alphar;
    ia=(Vm*sin(eta-fai)/Z)-(K*Wm/Ra)+(((K*Wm/Ra)-(Vm*sin(alphar-fai)/Z))*exp((alphar-eta)*cotg(fai)));
        if ia<=0   then                               // if current is discontinuous
            for beta=(alpha+0.1):0.1:360
            betar=beta*%pi/180;
            ia=(Vm*sin(betar-fai)/Z)-(K*Wm/Ra)+(((K*Wm/Ra)-(Vm*sin(alphar-fai)/Z))*exp((alphar-betar)*cotg(fai)));
                if ia<=0.00001 then
                break;
                end
            end
        Tor3(j,i)=((Vm*K*(cos(alphar)-cos(betar)))-(Wm*K^2*(betar-alphar)))/(%pi*Ra);
        else
        Tor3(j,i)=((Vm*K*(1+cos(alphar))/%pi)-(Wm*K^2))/Ra;
        end
        i=i+1;
    end
j=j+1;
end
plot(Wmi',Tor3','g','LineWidth',2)

for  alpha=120                      // For  Firing angle = 120 degree
alphar=alpha*%pi/180;
i=1;
    for Wm = - Wmo:10:Wmo;
    Wmi(j,i)=Wm;
    eta=%pi+alphar;
    ia=(Vm*sin(eta-fai)/Z)-(K*Wm/Ra)+(((K*Wm/Ra)-(Vm*sin(alphar-fai)/Z))*exp((alphar-eta)*cotg(fai)));
        if ia<=0   then                               // if current is discontinuous
            for beta=(alpha+0.1):0.1:360
            betar=beta*%pi/180;
            ia=(Vm*sin(betar-fai)/Z)-(K*Wm/Ra)+(((K*Wm/Ra)-(Vm*sin(alphar-fai)/Z))*exp((alphar-betar)*cotg(fai)));
                if ia<=0.00001 then
                break;
                end
            end
        Tor4(j,i)=((Vm*K*(cos(alphar)-cos(betar)))-(Wm*K^2*(betar-alphar)))/(%pi*Ra);
        else
        Tor4(j,i)=((Vm*K*(1+cos(alphar))/%pi)-(Wm*K^2))/Ra;
        end
        i=i+1;
    end
j=j+1;
end
plot(Wmi',Tor4','c','LineWidth',2)
//legend('Firing Angle =30 degree','','Firing Angle =60 degree','','Firing Angle =90 degree','','Firing Angle =120 degree')
xgrid
title(' Torque-Speed characteristics of single phase Full controlled rectifier fed separately excited DC motor','fontsize',3)
xlabel("SPEED --------->",'fontsize',3)
ylabel("TORQUE--------->",'fontsize',3)
//legends(["pqr";"xyz"],[[5;2],[3;4]], with_box=%f, opt="?")
legends(["Firing Angle =30 degree";"Firing Angle =60 degree";"Firing Angle =90 degree";"Firing Angle =120 degree"],[1 2 3 4], opt=1, font_size=1)
